function [exp,minmax] = exposure_collate()
%This function works on an exposure data directory structure and generates a
%sstructure which can be used by ur_analysis for normalization of
%exposures.
%input directory structure look at the syn_collate-directory.dia.
%Synatax:   [exp_struct] = exposure_collate();
%Input:     you will be prompted to point to the root of the directory
%               structure.
%Output:    exp_struct = structure of exposures.
%           minmax = the global minimum and maximum for each channel

%initialize.
minmax = [];

dir_root = uigetdir2('','Directory where the exposure data is kept');    %get the directory

dir_lv1 = dir(dir_root);    %get the file structure of the root dir.

%now lets crank through the directories
for i = 3:size(dir_lv1,1)   %level 1: always start on 3 as 1 and 2 are . and .. (Dir: 20110308...etc.)
    if dir_lv1(i).isdir     %if this is a directory continue; else case...who cares
        dir_lv2 = dir([dir_root,filesep,dir_lv1(i).name]);  %now get the directory structure of the next level
        dir_tmp = [dir_root,filesep,dir_lv1(i).name,filesep]; %the current level 2 directory 
        if dir_end(dir_lv2)     %Test if this is the end level
            %Get here later
            error('There is a strict directory structure, and this is not it.');    %did not mean to use a strict directory structure
            %But storing an x possible drill down directory structure in a
            %n possible cell array, turns out to be too unwieldy.  Look at
            %the stored ver0.2 if you want to resurrect this, but for now
            %we are deadlocking this.  Check dir_struct.dia for the proper
            %directory structure.
        else    %not the end yet(expected)
            for j = 3:size(dir_lv2,1)   %level 2: Care about the name of this level (Dir: WT, KO, etc.)
                dir_lv3 = dir([dir_tmp,dir_lv2(j).name]);   %get the third level
                dir_tmp2 = [dir_tmp,dir_lv2(j).name,filesep];  %the current level3 directory
                if dir_end(dir_lv3)
                    %Come back for this later
                    error('There is a strict directory structure, and this is not it.');
                else    %no the end yet(expected)
                    for k = 3:size(dir_lv3,1)   %level 3: The care about level (Dir: Layer23, Layer4, etc.)
                        if dir_lv3(k).isdir     %go forth; we don't care about files
                            dir_lv4 = dir([dir_tmp2,dir_lv3(k).name]);   %get the fourth level
                            dir_tmp3 = [dir_tmp2,dir_lv3(k).name,filesep];  %the current level 4 directory
                            if dir_end(dir_lv4)
                                error(['There is a strict directory structure, and this is not it.',dir_tmp3]);
                            else
                                for l = 3:size(dir_lv4,1)   %level 3: The care about level (Dir: Layer23, Layer4, etc.)
                                    if dir_lv4(l).isdir     %go forth; we don't care about files
                                        dir_lv5 = dir([dir_tmp3,dir_lv4(l).name]);   %get the fourth level
                                        dir_tmp4 = [dir_tmp3,dir_lv4(l).name,filesep];  %the current level 4 directory
                                        %we only care about the files now.
                                        if size(dir_lv5,1)>2    %no empty directories
                                            [exp_data] = process_files(dir_lv5,dir_tmp4);     %get the files we want to move
                                            %now store the exposure data
                                            exp.(['date_' dir_lv1(i).name]).(dir_lv2(j).name).(dir_lv3(k).name).(dir_lv4(l).name) = exp_data;
                                            if isempty(minmax)  %first time through
                                                minmax = [exp_data,exp_data(:,2)];
                                            else
                                                [minmax] = exp_minmax(minmax,exp_data);  %get the global min and max for each exposure
                                            end
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
    end
end
       
%--------------------------------------------------------------------------
%sub function to figure out if this level is only files, meaning this is
%the end dir.
function [is_end] = dir_end(dir_struct)

is_end = 0;  %initiate

for i = 3:size(dir_struct,1)    %go through the 
    is_end(i-2)=dir_struct(i).isdir;     %pull the isdir info
end

is_end = logical(1-max(is_end));       %readout of whether this directory has only files.

%--------------------------------------------------------------------------
%subfunction to seperate files from directories
function [exp_data] = process_files(dir_info,curr_dir)

curr_names = {dir_info.name};   %grab the all of the names
idx = [dir_info.isdir];   %grab all of the isdir numbers
filenames = curr_names(~idx);   %grab the files first
filenames = findfiletype(filenames,'.txt');  %only csvs

%filter for only the files we want
exp_data = [];
for j = 1:size(filenames,2);
    if ~isempty(strfind(filenames{j},'session'))
        %process a session file
        fid = fopen([curr_dir,filenames{j}]);  %open file
        txt_tmp = textscan(fid,'%s%s%s%s%s%s%s','delimiter','\t');  %get data
        ch_tmp = txt_tmp{1}(4:end);
        exp_tmp = txt_tmp{2}(4:end);
        for i = 1:size(ch_tmp,1)  %reduce to only the labels
            if isempty(strfind(ch_tmp{i},'DAPI'))  %no DAPI
                ch_loc = isstrprop(ch_tmp{i},'wspace');
                ch_loc = find(ch_loc==1);
                try
                    curr_ch = ch_tmp{i}(ch_loc(1)+1:ch_loc(2)-1);
                catch
                    keyboard
                end
                exp_data = vertcat(exp_data,{curr_ch,str2double(exp_tmp{i})});
            end
        end
        fclose(fid);
    else %it is a prop file
        if isempty(strfind(filenames{j},'DAPI'))&& ~isempty(strfind(filenames{j},'_'))  %don't process DAPI or files that does not _
            %process a single metadata file
            fid = fopen([curr_dir,filenames{j}]);  %open file
            txt_tmp = textscan(fid,'%s%s%s%s%s%s%s%s','delimiter','\t');  %get data
            %Pull the specific data
            curr_ch = txt_tmp{1}{2};
            exp_time = str2num(txt_tmp{8}{2});
            %now extract out the actual channel name
            ch_loc = isstrprop(curr_ch,'wspace');
            ch_loc = find(ch_loc==1);
            try
                curr_ch = curr_ch(ch_loc(1)+1:ch_loc(2)-1);
            catch
                keyboard
            end
            exp_data = vertcat(exp_data,{curr_ch,exp_time});
            fclose(fid);
        end
    end
end
%display directory with overlapping channels
[ch_uni,uni_idx] = unique(exp_data(:,1));
if size(exp_data,1)>size(ch_uni,1)
    non_uni = setdiff(linspace(1,size(exp_data,1),size(exp_data,1)),uni_idx);
    non_uni = exp_data(non_uni);
    disp([curr_dir ' : ' non_uni{1:end}]);
end
%--------------------------------------------------------------------------
%this function generates the minmax array
function [minmax] = exp_minmax(minmax,exp_data)
for i = 1:size(exp_data,1)
    [exp_tmp,idx] = curr_ch_exp(exp_data{i,1},minmax);
    if ischar(exp_tmp)  %didn't find a match
        minmax = vertcat(minmax,[exp_data(i,:),exp_data(i,2)]);
    else  %did find a match
        if exp_data{i,2}>minmax{idx,2}  %bigger than max
            minmax{idx,2} = exp_data{i,2};
        elseif exp_data{i,2}<minmax{idx,3}  %smaller than min
            minmax{idx,3} = exp_data{i,2};
        end
    end
end
%--------------------------------------------------------------------------
%a little function to find the corresponding exposure for this channel
function [curr_exp,i] = curr_ch_exp(curr_ch,exp_list)
for i = 1:size(exp_list,1)  %go through the list
    if strcmpi(exp_list(i,1),curr_ch)  %found it
        curr_exp = exp_list{i,2};
        break
    elseif i==size(exp_list,1)  %didn't find any, return error
        curr_exp = ['Did not find a match for: ',curr_ch];
    end
end